<link href="{assetPath file='store.css'}?v={$versionHash}" rel="stylesheet">

<div class="landing-page bg-white nordvpn">

    <div class="hero">
        <div class="container">
            <div class="hero-bg">
                <div class="row h-100">
                    <div class="col-12 col-lg-6 my-auto">
                        <h1>{lang key="store.nordvpn.hero.title" tagOpen="<span>" tagClose="</span>" tagBreak="<br class=\"br-md-space br-lg-reg br-xl-space\">"}</h1>
                        <p>{lang key="store.nordvpn.hero.tagline" tagBreak="<br class=\"br-xs-space br-sm-space br-md-reg br-lg-space\">"}</p>
                        <button class="btn btn-default btn-get-nord" onclick="smoothScroll('#nordPricing')">
                            {lang key="store.nordvpn.shared.get"}
                        </button>
                        <p class="guarantee">{lang key="store.nordvpn.hero.guarantee"}</p>
                    </div>
                    <div class="col-6 d-none d-lg-block my-auto">
                        <img src="{$WEB_ROOT}/assets/img/marketconnect/nordvpn/header-image.png">
                    </div>
                    <div class="col-12 available">
                        <div class="row divider">
                            <span class="line"></span>
                            <p>{lang key="store.nordvpn.hero.available"}</p>
                            <span class="line"></span>
                        </div>

                        <img src="{$WEB_ROOT}/assets/img/marketconnect/nordvpn/header-icons.png">
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="feature icon">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <h1>{lang key="store.nordvpn.features.icon.title1"}</h1>
                </div>
                <div class="col-6 col-lg-3 big-screen-text-left">
                    <img src="{$WEB_ROOT}/assets/img/marketconnect/nordvpn/icon-global.svg">
                    <p>{lang key="store.nordvpn.features.icon.global"}</p>
                </div>
                <div class="col-6 col-lg-3 big-screen-text-left">
                    <img src="{$WEB_ROOT}/assets/img/marketconnect/nordvpn/icon-video.svg">
                    <p>{lang key="store.nordvpn.features.icon.video"}</p>
                </div>
                <div class="col-6 col-lg-3 big-screen-text-left">
                    <img src="{$WEB_ROOT}/assets/img/marketconnect/nordvpn/icon-hacker.svg">
                    <p>{lang key="store.nordvpn.features.icon.hacker"}</p>
                </div>
                <div class="col-6 col-lg-3 big-screen-text-left">
                    <img src="{$WEB_ROOT}/assets/img/marketconnect/nordvpn/icon-property.svg">
                    <p>{lang key="store.nordvpn.features.icon.property"}</p>
                </div>
            </div>
        </div>
    </div>

    <div class="feature comparison">
        <div class="container">
            <h1>{lang key="store.nordvpn.features.comparison.title"}</h1>
            <div class="comparison-container">
                <div class="row no-gutters">
                    <div class="col-12">
                        <div class="row no-gutters">
                            <div class="col-2"></div>
                            <div class="col-2"></div>
                            <div class="col-2"></div>
                            <div class="col-2"></div>
                            <div class="col-2"></div>
                            <div class="col-2"></div>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="row no-gutters">
                            <div class="col-2"></div>
                            <div class="col-2">
                                <span><img src="{$WEB_ROOT}/assets/img/marketconnect/nordvpn/vpn-nord.png"></span>
                            </div>
                            <div class="col-2">
                                <span><img src="{$WEB_ROOT}/assets/img/marketconnect/nordvpn/vpn-express.png"></span>
                            </div>
                            <div class="col-2">
                                <span><img src="{$WEB_ROOT}/assets/img/marketconnect/nordvpn/vpn-private.png"></span>
                            </div>
                            <div class="col-2">
                                <span><img src="{$WEB_ROOT}/assets/img/marketconnect/nordvpn/vpn-proton.png"></span>
                            </div>
                            <div class="col-2">
                                <span><img src="{$WEB_ROOT}/assets/img/marketconnect/nordvpn/vpn-pure.png"></span>
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="row no-gutters">
                            <div class="col-2">
                                <span>{lang key="store.nordvpn.features.comparison.speed1"}</span>
                            </div>
                            <div class="col-2">
                                <span><strong>{lang key="store.nordvpn.features.comparison.speed2"}</strong></span>
                            </div>
                            <div class="col-2">
                                <span>{lang key="store.nordvpn.features.comparison.speed3"}</span>
                            </div>
                            <div class="col-2">
                                <span>{lang key="store.nordvpn.features.comparison.speed4"}</span>
                            </div>
                            <div class="col-2">
                                <span>{lang key="store.nordvpn.features.comparison.speed5"}</span>
                            </div>
                            <div class="col-2">
                                <span>{lang key="store.nordvpn.features.comparison.speed6"}</span>
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="row no-gutters">
                            <div class="col-2">
                                <span>{lang key="store.nordvpn.features.comparison.vpn1"}</span>
                            </div>
                            <div class="col-2">
                                <span><strong>{lang key="store.nordvpn.features.comparison.vpn2"}</strong></span>
                            </div>
                            <div class="col-2">
                                <span>{lang key="store.nordvpn.features.comparison.vpn3"}</span>
                            </div>
                            <div class="col-2">
                                <span>{lang key="store.nordvpn.features.comparison.vpn4"}</span>
                            </div>
                            <div class="col-2">
                                <span>{lang key="store.nordvpn.features.comparison.vpn5"}</span>
                            </div>
                            <div class="col-2">
                                <span>{lang key="store.nordvpn.features.comparison.vpn6"}</span>
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="row no-gutters">
                            <div class="col-2">
                                <span>{lang key="store.nordvpn.features.comparison.log"}</span>
                            </div>
                            <div class="col-2">
                                <span><img src="{$WEB_ROOT}/assets/img/marketconnect/nordvpn/tick-yes.png"></span>
                            </div>
                            <div class="col-2">
                                <span><img src="{$WEB_ROOT}/assets/img/marketconnect/nordvpn/tick-no.png"></span>
                            </div>
                            <div class="col-2">
                                <span><img src="{$WEB_ROOT}/assets/img/marketconnect/nordvpn/tick-no.png"></span>
                            </div>
                            <div class="col-2">
                                <span><img src="{$WEB_ROOT}/assets/img/marketconnect/nordvpn/tick-no.png"></span>
                            </div>
                            <div class="col-2">
                                <span><img src="{$WEB_ROOT}/assets/img/marketconnect/nordvpn/tick-no.png"></span>
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="row no-gutters">
                            <div class="col-2">
                                <span>{lang key="store.nordvpn.features.comparison.chat"}</span>
                            </div>
                            <div class="col-2">
                                <span><img src="{$WEB_ROOT}/assets/img/marketconnect/nordvpn/tick-yes.png"></span>
                            </div>
                            <div class="col-2">
                                <span><img src="{$WEB_ROOT}/assets/img/marketconnect/nordvpn/tick-yes.png"></span>
                            </div>
                            <div class="col-2">
                                <span><img src="{$WEB_ROOT}/assets/img/marketconnect/nordvpn/tick-no.png"></span>
                            </div>
                            <div class="col-2">
                                <span><img src="{$WEB_ROOT}/assets/img/marketconnect/nordvpn/tick-yes.png"></span>
                            </div>
                            <div class="col-2">
                                <span><img src="{$WEB_ROOT}/assets/img/marketconnect/nordvpn/tick-yes.png"></span>
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="row no-gutters">
                            <div class="col-2">
                                <span>{lang key="store.nordvpn.features.comparison.wireguard"}</span>
                            </div>
                            <div class="col-2">
                                <span><img src="{$WEB_ROOT}/assets/img/marketconnect/nordvpn/tick-yes.png"></span>
                            </div>
                            <div class="col-2">
                                <span><img src="{$WEB_ROOT}/assets/img/marketconnect/nordvpn/tick-yes.png"></span>
                            </div>
                            <div class="col-2">
                                <span><img src="{$WEB_ROOT}/assets/img/marketconnect/nordvpn/tick-no.png"></span>
                            </div>
                            <div class="col-2">
                                <span><img src="{$WEB_ROOT}/assets/img/marketconnect/nordvpn/tick-yes.png"></span>
                            </div>
                            <div class="col-2">
                                <span><img src="{$WEB_ROOT}/assets/img/marketconnect/nordvpn/tick-yes.png"></span>
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="row no-gutters">
                            <div class="col-2"></div>
                            <div class="col-2">
                                <span>
                                    <button class="btn btn-default btn-get-nord btn-get-deal" onclick="smoothScroll('#nordPricing')">{lang key="store.nordvpn.shared.get"}</button>
                                </span>
                            </div>
                            <div class="col-2"></div>
                            <div class="col-2"></div>
                            <div class="col-2"></div>
                            <div class="col-2"></div>
                        </div>
                    </div>
                </div>
            </div>
            <p class="comparison-note">{lang key="store.nordvpn.features.comparison.asterisk" tagOpen="<a class=\"blue\" href=\"https://www.av-comparatives.org/wp-content/uploads/2025/02/phishing_comp_Q1-2025.pdf\" target=\"_blank\">" tagClose="</a>" tagBreak="<br class=\"br-xs-space\">"}</p>
        </div>
    </div>

    <div class="feature threat">
        <div class="container">
            <div class="row justify-content-center title-div">
                <div class="col-10 col-sm-8">
                    <h1>{lang key="store.nordvpn.features.threat.title"}</h1>
                    <p>{lang key="store.nordvpn.features.threat.tagline" tagOpen="<strong>" tagClose="</strong>"}</p>
                </div>
            </div>
            <div class="row threats-div">
                <div class="col-10 col-md-4 text-left">
                    <img src="{$WEB_ROOT}/assets/img/marketconnect/nordvpn/img-protection.svg">
                    <p>{lang key="store.nordvpn.features.threat.protection" tagOpen="<strong>" tagClose="</strong>"}</p>
                </div>
                <div class="col-10 col-md-4 text-left">
                    <img src="{$WEB_ROOT}/assets/img/marketconnect/nordvpn/img-malware.svg">
                    <p>{lang key="store.nordvpn.features.threat.malware" tagOpen="<strong>" tagClose="</strong>"}</p>
                </div>
                <div class="col-10 col-md-4 text-left">
                    <img src="{$WEB_ROOT}/assets/img/marketconnect/nordvpn/img-safe.svg">
                    <p>{lang key="store.nordvpn.features.threat.safe" tagOpen="<strong>" tagClose="</strong>"}</p>
                </div>
            </div>
        </div>
    </div>

    <div class="feature device">
        <div class="container">
            <div class="row h-100">
                <div class="col-10 offset-1 col-lg-6 offset-lg-0 my-auto">
                    <img src="{$WEB_ROOT}/assets/img/marketconnect/nordvpn/img-man-phone.png">
                </div>
                <div class="col-10 offset-1 col-lg-6 offset-lg-0 my-auto">
                    <h3>{lang key="store.nordvpn.features.device.title1"}</h3>
                    <p>{lang key="store.nordvpn.features.device.tagline1"}</p>
                    <h3>{lang key="store.nordvpn.features.device.title2"}</h3>
                    <p>{lang key="store.nordvpn.features.device.tagline2"}</p>
                </div>
            </div>
        </div>
    </div>

    <div class="feature world">
        <div class="container">
            <div class="row">
                <div class="centered-row-responsive">
                    <img class="world-image" src="{$WEB_ROOT}/assets/img/marketconnect/nordvpn/img-world.svg">
                    <div class="world-desc">
                        <h1>{lang key="store.nordvpn.features.world.title"}</h1>
                        <p class="world-tagline">{lang key="store.nordvpn.features.world.tagline" tagBreak="<br class=\"br-xs-space br-lg-space br-xl-reg\">"}</p>
                        <div class="row world-data">
                            <div class="col-6">
                                <p>{lang key="store.nordvpn.features.world.bullet1"}</p>
                                <p>{lang key="store.nordvpn.features.world.count1"}</p>
                            </div>
                            <div class="col-6">
                                <p>{lang key="store.nordvpn.features.world.bullet2"}</p>
                                <p>{lang key="store.nordvpn.features.world.count2"}</p>
                            </div>
                            <div class="col-6">
                                <p>{lang key="store.nordvpn.features.world.bullet3"}</p>
                                <img src="{$WEB_ROOT}/assets/img/marketconnect/nordvpn/icon-speed.svg">
                            </div>
                            <div class="col-6">
                                <p>{lang key="store.nordvpn.features.world.bullet4"}</p>
                                <img src="{$WEB_ROOT}/assets/img/marketconnect/nordvpn/icon-infinity.svg">
                            </div>
                        </div>
                        <button class="btn btn-default btn-get-nord btn-get-deal" onclick="smoothScroll('#nordPricing')">
                            {lang key="store.nordvpn.features.world.getDeal"}
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="feature security">
        <div class="container">
            <div class="row">
                <div class="col-12 col-lg-6 my-auto text-center">
                    <img src="{$WEB_ROOT}/assets/img/marketconnect/nordvpn/privacy-no-logs-man-laptop-blue-md.png">
                </div>
                <div class="col-10 offset-1 col-lg-6 offset-lg-0 my-auto">
                    <h3>{lang key="store.nordvpn.features.security.title1"}</h3>
                    <p>{lang key="store.nordvpn.features.security.tagline1"}</p>
                    <p>{lang key="store.nordvpn.features.security.tagline2"}</p>
                </div>
            </div>
        </div>
    </div>

    <div class="feature icon">
        <div class="container">
            <div class="row">
                <div class="col-10 offset-1 col-md-12 offset-md-0 col-lg-4 text-left">
                    <img src="{$WEB_ROOT}/assets/img/marketconnect/nordvpn/extra-privacy.svg">
                    <h3>{lang key="store.nordvpn.features.security.title2"}</h3>
                    <p>{lang key="store.nordvpn.features.security.tagline3"}</p>
                </div>
                <div class="col-10 offset-1 col-md-12 offset-md-0 col-lg-4 text-left">
                    <img src="{$WEB_ROOT}/assets/img/marketconnect/nordvpn/no-logs.svg">
                    <h3>{lang key="store.nordvpn.features.security.title3"}</h3>
                    <p>{lang key="store.nordvpn.features.security.tagline4"}</p>
                </div>
                <div class="col-10 offset-1 col-md-12 offset-md-0 col-lg-4 text-left">
                    <img src="{$WEB_ROOT}/assets/img/marketconnect/nordvpn/online-security.svg">
                    <h3>{lang key="store.nordvpn.features.security.title4"}</h3>
                    <p>{lang key="store.nordvpn.features.security.tagline5"}</p>
                </div>
            </div>
        </div>
    </div>


    <div class="feature icon">
        <div class="container">
            <h1 class="text-center">{lang key="store.nordvpn.features.icon.title2"}</h1>
            <div class="row keep-data-safe-container">
                <div class="keep-data-safe-card text-left">
                    <img src="{$WEB_ROOT}/assets/img/marketconnect/nordvpn/fast-vpn-planet-girl-rocket-md.svg">
                    <h3>{lang key="store.nordvpn.features.icon.check1"}</h3>
                    <p>{lang key="store.nordvpn.features.icon.check2"}</p>
                </div>
                <div class="keep-data-safe-card text-left">
                    <img src="{$WEB_ROOT}/assets/img/marketconnect/nordvpn/vulnerability-detection-person-magnifying-search-md.svg">
                    <h3>{lang key="store.nordvpn.features.icon.bug1"}</h3>
                    <p>{lang key="store.nordvpn.features.icon.bug2"}</p>
                </div>
                <div class="keep-data-safe-card text-left">
                    <img src="{$WEB_ROOT}/assets/img/marketconnect/nordvpn/ad-blocker-malware-scanner-protection-md.svg">
                    <h3>{lang key="store.nordvpn.features.icon.shield1"}</h3>
                    <p>{lang key="store.nordvpn.features.icon.shield2"}</p>
                </div>
            </div>
        </div>
    </div>

    <div class="feature use">
        <div class="container">
            <h1>{lang key="store.nordvpn.features.use.title1"}</h1>
            <div class="row">
                <div class="col-10 offset-1">
                    <p>{lang key="store.nordvpn.features.use.tagline1" tagBreak="<br class=\"br-sm-space br-lg-reg\">"}</p>
                </div>
            </div>
            <div class="row">
                <div class="col-10 offset-1 offset-md-0 col-lg-4 text-left">
                    <h3>{lang key="store.nordvpn.features.use.title2"}</h3>
                    <p>{lang key="store.nordvpn.features.use.tagline2"}</p>
                </div>
                <div class="col-10 offset-1 offset-md-0 col-lg-4 text-left">
                    <h3>{lang key="store.nordvpn.features.use.title3"}</h3>
                    <p>{lang key="store.nordvpn.features.use.tagline3"}</p>
                </div>
                <div class="col-10 offset-1 offset-md-0 col-lg-4 text-left">
                    <h3>{lang key="store.nordvpn.features.use.title4"}</h3>
                    <p>{lang key="store.nordvpn.features.use.tagline4"}</p>
                </div>
            </div>
            <div class="row">
                <div class="col-10 offset-1 offset-md-0 col-lg-6 text-left">
                    <h3>{lang key="store.nordvpn.features.use.title5"}</h3>
                    <p>{lang key="store.nordvpn.features.use.tagline5"}</p>
                </div>
                <div class="col-10 offset-1 offset-md-0 col-lg-6 text-left">
                    <h3>{lang key="store.nordvpn.features.use.title6"}</h3>
                    <p>{lang key="store.nordvpn.features.use.tagline6"}</p>
                </div>
            </div>
        </div>
    </div>

    <div class="feature pricing" id="nordPricing">
        <div class="container">
            <h1>{lang key="store.nordvpn.features.pricing.title"}</h1>
            <div class="row">
                {foreach $plans as $plan}
                    {foreach $pricings[$plan->id] as $pricing}
                        <div class="{if $pricing@total == 1}col-sm-4 offset-sm-4{elseif $pricing@total == 2}col-sm-6{elseif $pricing@total == 2}col-sm-6{elseif $pricing@total == 3}col-md-4 col-sm-4{elseif $pricing@total == 4}col-xl-3 col-sm-6{elseif $pricing@total == 5}col-md-4 col-sm-6{else}col-lg-3 col-sm-4{/if}">
                            <span class="billing-cycle">
                                {if $inPreview}
                                    -
                                {else}
                                    {lang key="orderpaymentterm{$pricing->cycle()}"}
                                {/if}
                            </span>
                            <p class="billing-price">
                                {if $inPreview}
                                    -
                                {else}
                                    {$pricing->monthlyPrice()}
                                {/if}
                            </p>
                            <p class="billing-save">
                                {if $inPreview}
                                    -
                                {elseif $pricing->calculatePercentageDifference($highestMonthlyPrice) > 0}
                                    {lang key="store.nordvpn.features.pricing.save" amount=$pricing->calculatePercentageDifference($highestMonthlyPrice)}
                                {else}
                                    &nbsp;
                                {/if}
                            </p>
                            <div>
                                <form method="post" action="{routePath('cart-order-addtocart')}">
                                    <input type="hidden" name="checkout" value="1">
                                    <input type="hidden" name="pid" value="{$plan->id}">
                                    {if !$inPreview}
                                        <input type="hidden" name="billingcycle" value="{$pricing->cycle()}">
                                        <button class="btn btn-default btn-get-{$pricing->cycle()}" type="submit">
                                            {lang key="store.nordvpn.features.pricing.get"}
                                        </button>
                                    {/if}
                                </form>
                            </div>
                        </div>
                    {/foreach}
                {/foreach}
            </div>
        </div>
    </div>

    <div class="feature faq">
        <div class="container">
            <h1 class="text-center">{lang key="store.nordvpn.features.faq.title"}</h1>
            <div class="row justify-content-center">
                <div class="col-lg-7">
                    <div class="accordion" id="nordvpnFaq">
                        <div class="card">
                            <div class="card-header" id="heading1">
                                <h2 class="mb-0">
                                    <button class="btn btn-link btn-block text-left" type="button" data-toggle="collapse" data-target="#collapse1" aria-expanded="true" aria-controls="collapse1">
                                        {lang key="store.nordvpn.features.faq.question1"}
                                        <i class="fal fa-chevron-up fa-lg"></i>
                                    </button>
                                </h2>
                            </div>
                            <div id="collapse1" class="collapse show" aria-labelledby="heading1" data-parent="#nordvpnFaq">
                                <div class="card-body">
                                    {lang key="store.nordvpn.features.faq.answer1" tagOpen="<strong>" tagClose="</strong>"}
                                </div>
                            </div>
                        </div>
                        <div class="card">
                            <div class="card-header" id="heading2">
                                <h2 class="mb-0">
                                    <button class="btn btn-link btn-block text-left" type="button" data-toggle="collapse" data-target="#collapse2" aria-expanded="true" aria-controls="collapse2">
                                        {lang key="store.nordvpn.features.faq.question2"}
                                        <i class="fal fa-chevron-down fa-lg"></i>
                                    </button>
                                </h2>
                            </div>
                            <div id="collapse2" class="collapse" aria-labelledby="heading2" data-parent="#nordvpnFaq">
                                <div class="card-body">
                                    {lang key="store.nordvpn.features.faq.answer2"}
                                </div>
                            </div>
                        </div>
                        <div class="card">
                            <div class="card-header" id="heading3">
                                <h2 class="mb-0">
                                    <button class="btn btn-link btn-block text-left" type="button" data-toggle="collapse" data-target="#collapse3" aria-expanded="true" aria-controls="collapse3">
                                        {lang key="store.nordvpn.features.faq.question3"}
                                        <i class="fal fa-chevron-down fa-lg"></i>
                                    </button>
                                </h2>
                            </div>
                            <div id="collapse3" class="collapse" aria-labelledby="heading3" data-parent="#nordvpnFaq">
                                <div class="card-body">
                                    {lang key="store.nordvpn.features.faq.answer3"}
                                </div>
                            </div>
                        </div>
                        <div class="card">
                            <div class="card-header" id="heading4">
                                <h2 class="mb-0">
                                    <button class="btn btn-link btn-block text-left" type="button" data-toggle="collapse" data-target="#collapse4" aria-expanded="true" aria-controls="collapse4">
                                        {lang key="store.nordvpn.features.faq.question4"}
                                        <i class="fal fa-chevron-down fa-lg"></i>
                                    </button>
                                </h2>
                            </div>
                            <div id="collapse4" class="collapse" aria-labelledby="heading4" data-parent="#nordvpnFaq">
                                <div class="card-body">
                                    {lang key="store.nordvpn.features.faq.answer4"}
                                </div>
                            </div>
                        </div>
                        <div class="card">
                            <div class="card-header" id="heading5">
                                <h2 class="mb-0">
                                    <button class="btn btn-link btn-block text-left" type="button" data-toggle="collapse" data-target="#collapse5" aria-expanded="true" aria-controls="collapse5">
                                        {lang key="store.nordvpn.features.faq.question5"}
                                        <i class="fal fa-chevron-down fa-lg"></i>
                                    </button>
                                </h2>
                            </div>
                            <div id="collapse5" class="collapse" aria-labelledby="heading5" data-parent="#nordvpnFaq">
                                <div class="card-body">
                                    {lang key="store.nordvpn.features.faq.answer5"}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>

<script>
    jQuery(document).ready(function() {
        jQuery('.accordion .card-header .btn').on('click', function() {
            var icon = jQuery(this).find('i');
            if (icon.hasClass('fa-chevron-up')) {
                jQuery('.accordion .card-header .btn i.fa-chevron-down').removeClass('fa-chevron-down').addClass('fa-chevron-up');
                icon.removeClass('fa-chevron-up').addClass('fa-chevron-down');
            } else {
                icon.removeClass('fa-chevron-down').addClass('fa-chevron-up');
            }
        });
    });
</script>
